from typing import Optional

from ..tokenset import TokenSet
from .base import TokenCache


class MemoryTokenCache(TokenCache):
    """
    An in-memory token cache. Tokens are lost when the application exits.
    Suitable for testing or short-lived applications.
    """

    def __init__(self) -> None:
        self.__cache: Optional[TokenSet] = None

    def load(self) -> Optional[TokenSet]:
        return self.__cache

    def save(self, token_set: TokenSet) -> None:
        self.__cache = token_set

    def clear(self) -> None:
        self.__cache = None
