from abc import ABC, abstractmethod
from typing import Optional

from ..tokenset import TokenSet


class TokenCache(ABC):

    @abstractmethod
    def load(self) -> Optional[TokenSet]:
        """
        Load the token set from the cache.

        Returns:
            The loaded token set, or None if not found.

        Raises:
            TokenCacheLoadError: If there is an error loading the token set.
        """

    @abstractmethod
    def save(self, token_set: TokenSet) -> None:
        """
        Save the token set to the cache.

        Args:
            token_set: The token set to save.

        Raises:
            TokenCacheSaveError: If there is an error saving the token set.
        """

    @abstractmethod
    def clear(self) -> None:
        """
        Clear the token set from the cache.

        Raises:
            TokenCacheClearError: If there is an error clearing the token set.
        """
