# acmadauth

Device flow authentication helper for Keycloak OIDC clients, designed for use
in end-user applications. It provides a handler for the device authorisation
flow and an httpx auth class that injects bearer tokens and refreshes them as
needed.

## Installation

```bash
pip install --extra-index-url=https://pypi.acmad.cloud.edu.au/ acmadauth
```

## Usage

```python
from acmadauth.handlers import KeycloakOIDCDeviceFlowHandler
from acmadauth.tokencaches import MemoryTokenCache
from pprint import pprint
from acmadauth.auth import HttpxDeviceFlowAuth
import httpx

realm = "https://auth.acmad.cloud.edu.au/realms/ACMADCI"
client_id = "acmad-ci"

handler = KeycloakOIDCDeviceFlowHandler(realm, client_id)
cache = MemoryTokenCache()

auth = HttpxDeviceFlowAuth(handler, cache, open_browser=True)

client = httpx.Client(auth=auth)
resp = client.get("https://acmad-ci.acmad.cloud.edu.au/api/v1/user/current_user/")
print(f"Request Status Code: {resp.status_code}")
pprint(resp.json())
```

## Notes

- JWT signatures are not verified. Tokens are used only for expiry checks and transport.
- Use `KeyringTokenCache` for secure storage. `JsonFileTokenCache` is for testing only.

## Documentation

API documentation is available [here](https://auth-docs.acmad.cloud.edu.au/index.html).