"""Schemas used for validating external data structures."""


from marshmallow import EXCLUDE, Schema, fields


class TokenResponseSchema(Schema):
    """
    Schema for validating token response data from the OIDC provider (Keycloak).
    """
    access_token = fields.Str(required=True)
    expires_in = fields.Int(allow_none=True, required=False, load_default=None)
    refresh_token = fields.Str(
        allow_none=True,
        required=False,
        load_default=None)
    refresh_expires_in = fields.Int(
        allow_none=True,
        required=False,
        load_default=None)
    scope = fields.Str(allow_none=True, required=False, load_default=None)
    token_type = fields.Str(allow_none=True, required=False, load_default=None)

    class Meta:
        unknown = EXCLUDE
