"""Custom exceptions for the acmadauth module."""


class TokenCacheError(Exception):
    """Base class for token cache related errors."""


class TokenCacheLoadError(TokenCacheError):
    """Raised when loading the token cache fails."""


class TokenCacheSaveError(TokenCacheError):
    """Raised when saving to the token cache fails."""


class TokenCacheClearError(TokenCacheError):
    """Raised when clearing the token cache fails."""


class OIDCError(RuntimeError):
    """Raised for general OIDC errors."""


class OIDCDiscoveryError(OIDCError):
    """Raised when OIDC discovery fails."""


class DeviceAuthError(OIDCError):
    """Raised when device authentication fails."""


class TokenSetError(OIDCError):
    """Raised when there is an error with the token set."""
