import time

from acmadauth import tokenset
from acmadauth.tokenset import JWTToken


def test_is_expired_uses_expires_in_when_decode_fails(monkeypatch):
    def boom(*args, **kwargs):
        raise Exception("decode failed")

    monkeypatch.setattr(tokenset.jwt, "decode", boom)

    token = JWTToken(token="not-a-jwt", expires_in=1, time_obtained=time.time() - 10)
    assert token.is_expired() is True


def test_is_not_expired_uses_expires_in_when_decode_fails(monkeypatch):
    def boom(*args, **kwargs):
        raise Exception("decode failed")

    monkeypatch.setattr(tokenset.jwt, "decode", boom)

    token = JWTToken(token="not-a-jwt", expires_in=3600, time_obtained=time.time())
    assert token.is_expired() is False


def test_is_expired_when_no_exp_or_expires_in(monkeypatch):
    monkeypatch.setattr(tokenset.jwt, "decode", lambda *args, **kwargs: {})

    token = JWTToken(token="no-exp", expires_in=None, time_obtained=time.time())
    assert token.is_expired() is True


def test_from_token_response_preserves_token_type():
    data = {
        "access_token": "access",
        "refresh_token": "refresh",
        "expires_in": 3600,
        "token_type": "MAC",
    }

    token_set = tokenset.TokenSet.from_token_response(data)
    assert token_set.token_type == "MAC"
